import matplotlib.pyplot as plt
import seaborn as sns
import os
from sklearn.preprocessing import LabelEncoder
from sklearn.model_selection import train_test_split
from sklearn.metrics import classification_report, confusion_matrix
from sklearn.linear_model import LogisticRegression
from sklearn.metrics import accuracy_score
from sklearn.preprocessing import StandardScaler
from sklearn.cluster import KMeans
from sklearn.metrics import silhouette_score
import numpy as np
from scipy import stats
import sys
sys.path.append(sys.argv[1])

import pandas as pd   
import pickle
from decision_company import read_csv_file, avg, locate_mode, get_max, get_min_value, calculate_median

# Load the dataset  
credit_customers = read_csv_file(os.path.join(sys.argv[1], 'credit_customers.csv'))  
  
# Descriptive statistics for age  
age_column = credit_customers['age']  
age_mean = avg(age_column)  
age_median = calculate_median(credit_customers, 'age')  
age_mode = locate_mode(age_column)[0]  
age_range = get_max(age_column) - get_min_value(age_column) 
  
print(f"Age - Mean: {age_mean}, Median: {age_median}, Mode: {age_mode}, Range: {age_range}")  
# pickle.dump(age_mean, open("./ref_result/age_mean.pkl","wb"))
# pickle.dump(age_median, open("./ref_result/age_median.pkl","wb"))
# pickle.dump(age_mode, open("./ref_result/age_mode.pkl","wb"))
# pickle.dump(age_range, open("./ref_result/age_range.pkl","wb"))

  

import pandas as pd   
import matplotlib.pyplot as plt   
import seaborn as sns
from decision_company import read_csv_file, create_histogram, create_figure, set_plot_xlabel, create_figure, set_plot_title, set_yaxis_label, show_plots, save_plot

# Load the dataset  
  
# Distribution plot for age  
create_figure((10, 6))  
create_histogram(data=credit_customers, x='age', kde=True, bins=20)  
set_plot_title("Age Distribution")  
set_plot_xlabel("Age")  
set_yaxis_label("Frequency")  
save_plot('./ref_result/histplot.png')  
# show_plots()   


